/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWXMLData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkTestDataField;
import filenet.vw.toolkit.runtime.VWTrkWorkObject;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.Vector;

public class VWTrkDataField {
    public static final int FIELD_ACCESS_READ = 0;
    public static final int FIELD_ACCESS_WRITE = 1;
    public static final int FIELD_ACCESS_READWRITE = 2;
    public static final int ATTACHMENT_PREDEFINED = 0;
    public static final int ATTACHMENT_DYNAMIC = 1;
    private String m_name = null;
    private int m_type = 0;
    private String m_description = null;
    private boolean m_bArray = false;
    private Object m_displayValue = null;
    private int m_mode = 0;
    private boolean m_bAppendAttachments = true;

    public VWTrkDataField(VWTrkTestDataField dataField) throws Exception {
        if (dataField == null || dataField.getIsSystemField()) {
            String string = dataField == null ? VWResource.s_errorCreatingVWTrkDataFieldObjectNullDataField : VWResource.s_errorCreatingVWTrkDataFieldObjectNoSystemField;
            Exception ex = new Exception(string);
            throw ex;
        }
        this.m_name = dataField.getName();
        this.m_type = dataField.getFieldType();
        this.m_bArray = dataField.isArray();
        this.m_description = dataField.getDescription();
        this.m_displayValue = null;
        this.collateDataField(dataField);
    }

    public void updateDataFields(Vector wobCollection) {
        if (wobCollection == null) {
            return;
        }
        this.m_displayValue = null;
        for (int i = 0; i < wobCollection.size(); ++i) {
            VWTrkWorkObject wob = (VWTrkWorkObject)wobCollection.elementAt(i);
            if (wob == null) continue;
            try {
                this.collateDataField(wob.getFieldValue(this.m_name));
                continue;
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
        }
    }

    public void writeDataFieldsToWorkObjects(Vector wobCollection) {
        if (this.m_displayValue instanceof Vector) {
            return;
        }
        if (wobCollection == null) {
            return;
        }
        for (int i = 0; i < wobCollection.size(); ++i) {
            VWTrkWorkObject wob = (VWTrkWorkObject)wobCollection.elementAt(i);
            if (wob == null) continue;
            try {
                int type = VWFieldType.getVWFieldType(this.m_displayValue);
                wob.setFieldValue(this.m_name, this.m_displayValue);
                continue;
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
        }
    }

    public void collateDataField(VWTrkTestDataField dataField) {
        if (dataField == null) {
            return;
        }
        if (!this.isSameDataField(dataField.getName())) {
            return;
        }
        if (this.m_bArray) {
            this.collateArray(dataField);
        } else {
            this.collateSimpleField(dataField);
        }
    }

    protected boolean isSameDataField(String name) {
        if (name == null) {
            return false;
        }
        return VWStringUtils.compare(this.m_name, name) == 0;
    }

    public void collateDataField(Object value) {
        if (value == null) {
            return;
        }
        if (this.m_bArray) {
            this.collateArray(value);
        } else {
            this.collateSimpleField(value);
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public int getMode() {
        return this.m_mode;
    }

    public void setMode(int mode) {
        this.m_mode = mode;
    }

    public boolean isArray() {
        return this.m_bArray;
    }

    public boolean isVariousValues() {
        if (this.m_displayValue == null) {
            return false;
        }
        return this.m_displayValue instanceof Vector;
    }

    public int getType() {
        return this.m_type;
    }

    public Object getDisplayValue() {
        return this.m_displayValue;
    }

    protected void collateSimpleField(VWTrkTestDataField dataField) {
        if (dataField == null) {
            return;
        }
        Object value = dataField.getValue();
        this.collateSimpleField(value);
    }

    protected void collateSimpleField(Object value) {
        if (value == null) {
            return;
        }
        Object obj = null;
        switch (this.m_type) {
            case 1: {
                if (!(value instanceof Integer)) {
                    return;
                }
                obj = new Integer((Integer)value);
                break;
            }
            case 16: {
                if (!(value instanceof Date)) {
                    return;
                }
                obj = new Date(((Date)value).getTime());
                break;
            }
            case 2: {
                if (!(value instanceof String)) {
                    return;
                }
                obj = (String)value;
                break;
            }
            case 4: {
                if (!(value instanceof Boolean)) {
                    return;
                }
                obj = new Boolean((Boolean)value);
                break;
            }
            case 8: {
                if (!(value instanceof Double)) {
                    return;
                }
                obj = new Double((Double)value);
                break;
            }
            case 32: {
                if (!(value instanceof VWAttachment)) {
                    return;
                }
                obj = (VWAttachment)value;
                break;
            }
            case 128: {
                if (!(value instanceof VWXMLData)) {
                    return;
                }
                obj = (VWXMLData)value;
                break;
            }
            default: {
                return;
            }
        }
        if (this.m_displayValue == null) {
            this.m_displayValue = obj;
        } else if (!this.isSameValue(value)) {
            if (!this.isVariousValues()) {
                Vector<Object> v = new Vector<Object>();
                v.addElement(this.m_displayValue);
                v.addElement(value);
                this.m_displayValue = v;
            } else if (this.isVariousValues()) {
                ((Vector)this.m_displayValue).addElement(obj);
            } else {
                Exception e = new Exception(VWResource.s_failedVWTrkDataFieldCollateSimpleField.toString(obj.getClass().toString()));
                VWDebug.logException(e);
            }
        }
    }

    protected void collateArray(VWTrkTestDataField dataField) {
        if (dataField == null) {
            return;
        }
        this.collateArray(dataField.getValue());
    }

    protected void collateArray(Object value) {
        if (value == null) {
            return;
        }
        switch (this.m_type) {
            case 1: {
                if (!(value instanceof Integer[])) break;
                this.collateIntegers((Integer[])value);
                break;
            }
            case 16: {
                if (!(value instanceof Date[])) break;
                this.collateDates((Date[])value);
                break;
            }
            case 2: {
                if (!(value instanceof String[])) break;
                this.collateStrings((String[])value);
                break;
            }
            case 4: {
                if (!(value instanceof Boolean[])) break;
                this.collateBooleans((Boolean[])value);
                break;
            }
            case 8: {
                if (!(value instanceof Double[])) break;
                this.collateFloats((Double[])value);
                break;
            }
            case 128: {
                if (!(value instanceof VWXMLData[])) break;
                this.collateXML((VWXMLData[])value);
                break;
            }
            case 32: {
                if (!(value instanceof VWAttachment[])) break;
                this.collateAttachments((VWAttachment[])value);
                break;
            }
            case 64: {
                if (!(value instanceof VWParticipant[])) break;
                this.collateWorkflowGroup((VWParticipant[])value);
            }
        }
    }

    protected boolean isSameValue(Object value) {
        if (this.m_displayValue == null || !value.getClass().isInstance(this.m_displayValue)) {
            return false;
        }
        if (value instanceof Integer) {
            return this.isSameInteger(value);
        }
        if (value instanceof Boolean) {
            return this.isSameBoolean(value);
        }
        if (value instanceof Date) {
            return this.isSameDate(value);
        }
        if (value instanceof Double) {
            return this.isSameFloat(value);
        }
        if (value instanceof String) {
            return this.isSameString(value);
        }
        if (value instanceof VWXMLData) {
            return this.isSameXML(value);
        }
        if (value instanceof VWAttachment) {
            return this.isSameAttachment(value);
        }
        return false;
    }

    protected boolean isSameInteger(Object value) {
        return value != null && value instanceof Integer && ((Integer)this.m_displayValue).equals(value);
    }

    protected boolean isSameDate(Object value) {
        return value != null && value instanceof Date && ((Date)this.m_displayValue).getTime() == ((Date)value).getTime();
    }

    protected boolean isSameString(Object value) {
        return value != null && value instanceof String && VWStringUtils.compare((String)this.m_displayValue, (String)value) == 0;
    }

    protected boolean isSameFloat(Object value) {
        return value != null && value instanceof Double && ((Double)this.m_displayValue).equals(value);
    }

    protected boolean isSameXML(Object value) {
        return value != null && value instanceof VWXMLData && VWStringUtils.compare(((VWXMLData)this.m_displayValue).getXML(), ((VWXMLData)value).getXML()) == 0;
    }

    protected boolean isSameBoolean(Object value) {
        return value != null && value instanceof Boolean && ((Boolean)this.m_displayValue).equals(value);
    }

    protected boolean isSameAttachment(Object value) {
        if (value != null && value instanceof VWAttachment) {
            VWAttachment attach1 = (VWAttachment)this.m_displayValue;
            VWAttachment attach2 = (VWAttachment)value;
            return this.isSameAttachment(attach1, attach2);
        }
        return false;
    }

    protected boolean isSameAttachment(VWAttachment attach1, VWAttachment attach2) {
        String str2;
        if (attach1 == attach2) {
            return true;
        }
        String str1 = attach1.getId();
        if (str1 != (str2 = attach2.getId()) && (str1 == null || str2 == null || VWStringUtils.compare(str1, str2) != 0)) {
            return false;
        }
        str1 = attach1.getVersion();
        if (str1 != (str2 = attach2.getVersion()) && (str1 == null || str2 == null || VWStringUtils.compare(str1, str2) != 0)) {
            return false;
        }
        str1 = attach1.getLibraryName();
        if (str1 != (str2 = attach2.getLibraryName()) && (str1 == null || str2 == null || VWStringUtils.compare(str1, str2) != 0)) {
            return false;
        }
        return attach1.getType() == attach2.getType();
    }

    protected boolean collateWorkflowGroup(VWParticipant[] value) {
        if (value == null) {
            return false;
        }
        VWParticipant[] wfGroup1 = (VWParticipant[])this.m_displayValue;
        VWParticipant[] wfGroup2 = null;
        VWParticipant[] wfGroup = null;
        try {
            wfGroup2 = VWDefaultSessionProxy.getFullParticipants(value, false);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            wfGroup2 = value;
        }
        if (wfGroup1 == null) {
            this.m_displayValue = wfGroup2;
            return true;
        }
        int count = 0;
        boolean bCollated = false;
        count = wfGroup1.length;
        wfGroup = new VWParticipant[count + wfGroup2.length];
        System.arraycopy(this.m_displayValue, 0, wfGroup, 0, count);
        boolean bNull = false;
        for (int i = 0; i < wfGroup2.length; ++i) {
            String name = wfGroup2[i].getParticipantName();
            if (name == null) {
                bNull = true;
                continue;
            }
            boolean bFound = false;
            for (int j = 0; j < wfGroup1.length; ++j) {
                if (wfGroup[j] == null) {
                    bNull = true;
                    continue;
                }
                if (wfGroup1[j].getParticipantName() == null) {
                    bNull = true;
                    continue;
                }
                if (VWStringUtils.compare(name, wfGroup1[j].getParticipantName()) != 0) continue;
                bFound = true;
                break;
            }
            if (bFound) continue;
            wfGroup[count++] = wfGroup2[i];
            bCollated = true;
        }
        if (bCollated) {
            if (count == wfGroup.length) {
                this.m_displayValue = wfGroup;
            } else {
                this.m_displayValue = new VWParticipant[count];
                System.arraycopy(wfGroup, 0, this.m_displayValue, 0, count);
            }
        }
        return bCollated;
    }

    protected boolean collateIntegers(Integer[] value) {
        if (value == null) {
            return false;
        }
        boolean bCollated = true;
        Integer[] list = new Integer[value.length];
        for (int i = 0; i < value.length; ++i) {
            list[i] = new Integer(value[i]);
        }
        if (this.m_displayValue != null) {
            Vector v = null;
            if (this.m_displayValue instanceof Integer[]) {
                v = new Vector();
                v.addElement(this.m_displayValue);
                this.m_displayValue = v;
            }
            if (this.m_displayValue instanceof Vector) {
                v = (Vector)this.m_displayValue;
                for (int i = 0; i < v.size(); ++i) {
                    if (!this.isSameArray(v.elementAt(i), list)) continue;
                    bCollated = false;
                    break;
                }
                if (bCollated) {
                    v.addElement(list);
                } else if (v.size() == 1) {
                    this.m_displayValue = v.elementAt(0);
                }
            }
        } else {
            this.m_displayValue = list;
            bCollated = false;
        }
        return bCollated;
    }

    protected boolean collateXML(VWXMLData[] value) {
        if (value == null) {
            return false;
        }
        boolean bCollated = true;
        VWXMLData[] list = new VWXMLData[value.length];
        for (int i = 0; i < value.length; ++i) {
            try {
                list[i] = new VWXMLData(value[i].getXML(), value[i].getSchemaName(), value[i].getElementName());
                continue;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        if (this.m_displayValue != null) {
            Vector v = null;
            if (this.m_displayValue instanceof VWXMLData[]) {
                v = new Vector();
                v.addElement(this.m_displayValue);
                this.m_displayValue = v;
            }
            if (this.m_displayValue instanceof Vector) {
                v = (Vector)this.m_displayValue;
                for (int i = 0; i < v.size(); ++i) {
                    if (!this.isSameArray(v.elementAt(i), list)) continue;
                    bCollated = false;
                    break;
                }
                if (bCollated) {
                    v.addElement(list);
                } else if (v.size() == 1) {
                    this.m_displayValue = v.elementAt(0);
                }
            }
        } else {
            this.m_displayValue = list;
            bCollated = false;
        }
        return bCollated;
    }

    protected boolean collateDates(Date[] value) {
        if (value == null) {
            return false;
        }
        boolean bCollated = true;
        Date[] list = new Date[value.length];
        for (int i = 0; i < value.length; ++i) {
            list[i] = new Date(value[i].getTime());
        }
        if (this.m_displayValue != null) {
            Vector v = null;
            if (this.m_displayValue instanceof Date[]) {
                v = new Vector();
                v.addElement(this.m_displayValue);
                this.m_displayValue = v;
            }
            if (this.m_displayValue instanceof Vector) {
                v = (Vector)this.m_displayValue;
                for (int i = 0; i < v.size(); ++i) {
                    if (!this.isSameArray(v.elementAt(i), list)) continue;
                    bCollated = false;
                    break;
                }
                if (bCollated) {
                    v.addElement(list);
                } else if (v.size() == 1) {
                    this.m_displayValue = v.elementAt(0);
                }
            }
        } else {
            this.m_displayValue = list;
            bCollated = false;
        }
        return bCollated;
    }

    protected boolean collateFloats(Double[] value) {
        if (value == null) {
            return false;
        }
        boolean bCollated = true;
        Double[] list = new Double[value.length];
        for (int i = 0; i < value.length; ++i) {
            list[i] = new Double(value[i]);
        }
        if (this.m_displayValue != null) {
            Vector v = null;
            if (this.m_displayValue instanceof Double[]) {
                v = new Vector();
                v.addElement(this.m_displayValue);
                this.m_displayValue = v;
            }
            if (this.m_displayValue instanceof Vector) {
                v = (Vector)this.m_displayValue;
                for (int i = 0; i < v.size(); ++i) {
                    if (!this.isSameArray(v.elementAt(i), list)) continue;
                    bCollated = false;
                    break;
                }
                if (bCollated) {
                    v.addElement(list);
                } else if (v.size() == 1) {
                    this.m_displayValue = v.elementAt(0);
                }
            }
        } else {
            this.m_displayValue = list;
            bCollated = false;
        }
        return bCollated;
    }

    protected boolean collateStrings(String[] value) {
        if (value == null) {
            return false;
        }
        boolean bCollated = true;
        String[] list = new String[value.length];
        for (int i = 0; i < value.length; ++i) {
            list[i] = value[i];
        }
        if (this.m_displayValue != null) {
            Vector v = null;
            if (this.m_displayValue instanceof String[]) {
                v = new Vector();
                v.addElement(this.m_displayValue);
                this.m_displayValue = v;
            }
            if (this.m_displayValue instanceof Vector) {
                v = (Vector)this.m_displayValue;
                for (int i = 0; i < v.size(); ++i) {
                    if (!this.isSameArray(v.elementAt(i), list)) continue;
                    bCollated = false;
                    break;
                }
                if (bCollated) {
                    v.addElement(list);
                } else if (v.size() == 1) {
                    this.m_displayValue = v.elementAt(0);
                }
            }
        } else {
            this.m_displayValue = list;
            bCollated = false;
        }
        return bCollated;
    }

    protected boolean collateBooleans(Boolean[] value) {
        if (value == null) {
            return false;
        }
        boolean bCollated = true;
        Boolean[] list = new Boolean[value.length];
        for (int i = 0; i < value.length; ++i) {
            list[i] = new Boolean(value[i]);
        }
        if (this.m_displayValue != null) {
            Vector v = null;
            if (this.m_displayValue instanceof Boolean[]) {
                v = new Vector();
                v.addElement(this.m_displayValue);
                this.m_displayValue = v;
            }
            if (this.m_displayValue instanceof Vector) {
                v = (Vector)this.m_displayValue;
                for (int i = 0; i < v.size(); ++i) {
                    if (!this.isSameArray(v.elementAt(i), list)) continue;
                    bCollated = false;
                    break;
                }
                if (bCollated) {
                    v.addElement(list);
                } else if (v.size() == 1) {
                    this.m_displayValue = v.elementAt(0);
                }
            }
        } else {
            this.m_displayValue = list;
            bCollated = false;
        }
        return bCollated;
    }

    protected boolean collateAttachments(VWAttachment[] value) {
        if (value == null) {
            return false;
        }
        boolean bCollated = true;
        if (this.m_bAppendAttachments) {
            VWAttachment[] attchArray1 = (VWAttachment[])this.m_displayValue;
            VWAttachment[] attchArray2 = value;
            VWAttachment[] attchArray = null;
            if (attchArray1 == null) {
                this.m_displayValue = attchArray2;
                return true;
            }
            int count = 0;
            count = attchArray1.length;
            attchArray = new VWAttachment[count + attchArray2.length];
            System.arraycopy(this.m_displayValue, 0, attchArray, 0, count);
            boolean bNull = false;
            for (int i = 0; i < attchArray2.length; ++i) {
                boolean bFound = false;
                for (int j = 0; j < attchArray1.length; ++j) {
                    if (!this.isSameAttachment(attchArray2[i], attchArray1[j])) continue;
                    bFound = true;
                    break;
                }
                if (bFound) continue;
                attchArray[count++] = attchArray2[i];
                bCollated = true;
            }
            if (bCollated) {
                if (count == attchArray.length) {
                    this.m_displayValue = attchArray;
                } else {
                    this.m_displayValue = new VWAttachment[count];
                    System.arraycopy(attchArray, 0, this.m_displayValue, 0, count);
                }
            }
        } else {
            VWAttachment[] list = new VWAttachment[value.length];
            for (int i = 0; i < value.length; ++i) {
                list[i] = value[i];
            }
            if (this.m_displayValue != null) {
                Vector v = null;
                if (this.m_displayValue instanceof VWAttachment[]) {
                    v = new Vector();
                    v.addElement(this.m_displayValue);
                    this.m_displayValue = v;
                }
                if (this.m_displayValue instanceof Vector) {
                    v = (Vector)this.m_displayValue;
                    for (int i = 0; i < v.size(); ++i) {
                        if (!this.isSameArray(v.elementAt(i), list)) continue;
                        bCollated = false;
                        break;
                    }
                    if (bCollated) {
                        v.addElement(list);
                    } else if (v.size() == 1) {
                        this.m_displayValue = v.elementAt(0);
                    }
                }
            } else {
                this.m_displayValue = list;
                bCollated = false;
            }
        }
        return bCollated;
    }

    public int getSize() {
        if (this.m_displayValue == null || !this.m_bArray) {
            return 1;
        }
        Object[] object = (Object[])this.m_displayValue;
        return object.length;
    }

    public String toString() {
        String string = new String();
        if (this.m_bArray) {
            if (this.m_displayValue instanceof Vector) {
                string = VWResource.s_variousValues;
            }
            Object[] array = (Object[])this.m_displayValue;
            Object value = null;
            for (int i = 0; i < array.length; ++i) {
                value = array[i];
                if (value == null) continue;
                if (i != 0) {
                    string = string + ";";
                }
                string = string + this.toString(value);
            }
        } else {
            string = this.toString(this.m_displayValue);
        }
        return string;
    }

    public String toString(int i) {
        if (this.m_bArray && this.m_displayValue instanceof Object[]) {
            Object[] array = (Object[])this.m_displayValue;
            Object value = null;
            if (i < array.length && (value = array[i]) != null) {
                return this.toString(((Object[])this.m_displayValue)[i]);
            }
        }
        return null;
    }

    protected String toString(Object value) {
        if (value instanceof Vector || value instanceof Object[]) {
            return null;
        }
        switch (this.m_type) {
            case 1: {
                return ((Integer)value).toString();
            }
            case 2: {
                return ((String)value).toString();
            }
            case 4: {
                return ((Boolean)value).toString();
            }
            case 8: {
                return ((Double)value).toString();
            }
            case 128: {
                return ((VWXMLData)value).toString();
            }
            case 32: {
                break;
            }
        }
        return null;
    }

    public Object getValue() {
        return this.m_displayValue;
    }

    public Object getValue(int i) {
        if (this.m_bArray && this.m_displayValue instanceof Object[]) {
            Object[] array = (Object[])this.m_displayValue;
            if (i >= 0 && i < array.length) {
                return array[i];
            }
        }
        return null;
    }

    public void setValue(Object value) throws Exception {
        if (value == null) {
            Exception ex = new Exception(VWResource.s_errorSettingDataFieldValue.toString(this.m_name, VWResource.s_nullValue));
            throw ex;
        }
        Object aValue = null;
        if (value instanceof Vector) {
            Vector v = (Vector)value;
            if (v.size() > 0) {
                aValue = v.elementAt(0);
            }
        } else {
            aValue = value;
        }
        if (!this.isTypeMatch(aValue)) {
            Exception ex = new Exception(VWResource.s_errorSettingDataFieldValue.toString(this.m_name, VWResource.s_typeMismatch));
            throw ex;
        }
        this.m_displayValue = value;
    }

    public void setValue(Object value, int index) throws Exception {
        if (this.m_displayValue instanceof Vector) {
            Exception ex = new Exception(VWResource.s_errorSettingDataFieldValue.toString(this.m_name, VWResource.s_invalidValue));
            throw ex;
        }
        if (value == null || value.getClass().isArray() || !this.m_bArray || !(this.m_displayValue instanceof Object[])) {
            Exception ex = new Exception(VWResource.s_errorSettingDataFieldValue.toString(this.m_name, VWResource.s_invalidValue));
            throw ex;
        }
        if (!this.isSimpleTypeMatch(value)) {
            Exception ex = new Exception(VWResource.s_errorSettingDataFieldValue.toString(this.m_name, VWResource.s_typeMismatch));
            throw ex;
        }
        Object[] array = (Object[])this.m_displayValue;
        if (index >= array.length) {
            Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), index + 1);
            if (array.length > 0) {
                System.arraycopy(array, 0, newArray, 0, array.length);
            }
            this.m_displayValue = newArray;
            array = newArray;
        }
        array[index] = value;
    }

    public void removeValue(int index) throws Exception {
        if (this.m_displayValue instanceof Vector) {
            Exception ex = new Exception(VWResource.s_errorRemovingDataFieldValue.toString(this.m_name, VWResource.s_attempRemoveNonArrayDataField));
            throw ex;
        }
        Object[] array = (Object[])this.m_displayValue;
        if (index >= array.length || array.length <= 0) {
            Exception ex = new Exception(VWResource.s_errorRemovingDataFieldValue.toString(this.m_name, VWResource.s_outOfBound));
            throw ex;
        }
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        System.arraycopy(array, 0, newArray, 0, index);
        if (index < array.length - 1) {
            System.arraycopy(array, index + 1, newArray, index, array.length - 1 - index);
        }
        this.m_displayValue = newArray;
        array = newArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isTypeMatch(Object value) {
        if (value == null) {
            return false;
        }
        boolean bArray = value.getClass().isArray();
        if (bArray != this.m_bArray) {
            return false;
        }
        Object aValue = null;
        if (bArray) {
            Object[] array = (Object[])value;
            if (!this.isArrayTypeMatch(array)) {
                return false;
            }
            if (array.length <= 0) return true;
            aValue = ((Object[])value)[0];
            if (aValue != null) return this.isSimpleTypeMatch(aValue);
            return false;
        }
        aValue = value;
        return this.isSimpleTypeMatch(aValue);
    }

    protected boolean isArrayTypeMatch(Object[] value) {
        if (value == null) {
            return false;
        }
        boolean bTypeMatch = false;
        switch (this.m_type) {
            case 1: {
                if (!(value instanceof Integer[])) break;
                bTypeMatch = true;
                break;
            }
            case 2: {
                if (!(value instanceof String[])) break;
                bTypeMatch = true;
                break;
            }
            case 4: {
                if (!(value instanceof Boolean[])) break;
                bTypeMatch = true;
                break;
            }
            case 16: {
                if (!(value instanceof Date[])) break;
                bTypeMatch = true;
                break;
            }
            case 8: {
                if (!(value instanceof Double[])) break;
                bTypeMatch = true;
                break;
            }
            case 128: {
                if (!(value instanceof VWXMLData[])) break;
                bTypeMatch = true;
                break;
            }
            case 32: {
                if (!(value instanceof VWAttachment[])) break;
                bTypeMatch = true;
                break;
            }
            case 64: {
                if (!(value instanceof VWParticipant[])) break;
                bTypeMatch = true;
            }
        }
        return bTypeMatch;
    }

    protected boolean isSimpleTypeMatch(Object value) {
        if (value == null) {
            return false;
        }
        boolean bTypeMatch = false;
        switch (this.m_type) {
            case 1: {
                if (!(value instanceof Integer)) break;
                bTypeMatch = true;
                break;
            }
            case 2: {
                if (!(value instanceof String)) break;
                bTypeMatch = true;
                break;
            }
            case 4: {
                if (!(value instanceof Boolean)) break;
                bTypeMatch = true;
                break;
            }
            case 16: {
                if (!(value instanceof Date)) break;
                bTypeMatch = true;
                break;
            }
            case 8: {
                if (!(value instanceof Double)) break;
                bTypeMatch = true;
                break;
            }
            case 128: {
                if (!(value instanceof VWXMLData)) break;
                bTypeMatch = true;
                break;
            }
            case 32: {
                if (!(value instanceof VWAttachment)) break;
                bTypeMatch = true;
                break;
            }
            case 64: {
                if (!(value instanceof VWParticipant)) break;
                bTypeMatch = true;
            }
        }
        return bTypeMatch;
    }

    private boolean isSameArray(Object a1, Object a2) {
        if (!a1.getClass().isArray() || !a2.getClass().isArray()) {
            return false;
        }
        if (a1.getClass().getComponentType() != a2.getClass().getComponentType()) {
            return false;
        }
        Object[] array1 = (Object[])a1;
        Object[] array2 = (Object[])a2;
        if (array1.length != array2.length) {
            return false;
        }
        if (array1 instanceof VWAttachment[]) {
            for (int i = 0; i < array1.length; ++i) {
                if (this.isSameAttachment((VWAttachment)array1[i], (VWAttachment)array2[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < array1.length; ++i) {
                if (array1[i].equals(array2[i])) continue;
                return false;
            }
        }
        return true;
    }

    public void removeReferences() {
        this.m_name = null;
        this.m_description = null;
        this.m_displayValue = null;
    }
}

